#!/usr/bin/python
class ErrorCode:
    """ eBackup error code list"""

    # The backup plan does not exist.
    PLAN_NON_EXISTENT = 1625299713

    # The copy plan does not exist
    COPY_PLAN_NON_EXISTENT = 1625299726

    BOMG_BACKUP_OBJ_ID_ILLEGAL = 1625297413

    # The backup plan is being deleted.
    PLAN_DELETING = 1625299715

    # The backup plan is busy.
    PLAN_HAVE_TASK = 1625299717

    # The copy policy does not exist
    COPY_POLICY_NOT_EXISTENT = 1625296926

    # The specified backup image does not exist.
    IMAGE_NON_EXISTENT = 1625299457

    # The backup image is being deleted.
    IMAGE_DELETING = 1625299462

    # The repository does not exist.
    REP_NON_EXISTENT = 1625295878

    # The specified storage pool does not exist.
    POOL_NON_EXISTENT = 1625296132

    # The storage unit does not exist.
    BRICK_NON_EXISTENT = 1625296391

    # Target VM has been used by a backup job.
    VM_HAS_USED = 1625299627

    # The number of current sessions has reached the upper limit.
    MAX_SESSIONS = 1610664620

    # The name already exists.
    EXISTS_NAME = 1610664364
    # Storage unit busy
    STORAGE_UNIT_BUSY = 1625296129

    FAULT_LOGOUT = 1610664361

    # The repository has associated job which is in Pending, In progress or Aborting status
    NAMESPACE_HAS_JOB = 1625295884

    INVALID_SESSION = 1610664354
    COMMUNICATION_FAILED = 4294967297

    TSKMG_TASK_ID_NOT_EXIST = 1625297411

    EC_LOGIN_CRED_WRONG = 1610664610
    EC_COM_INTERNAL_ERROR = 1610664353
    EC_COM_DB_ERROR = 1610664356

    EBK_IBASE_TIMEOUT = 16797698
    EC_COM_SYSTEM_BUSY = 1610664373

    # The capacity of storage unit not enough
    BRICK_CAPACITY_NOT_ENOUGH = 20202

    BD_LOGIN_EBACKUP_FALIED = 50000
    BD_CONNECT_EBACKUP_FALIED = 50001
    BD_IP_FORMAT_NOT_RIGHT = 50002
    BD_PORT_FORMAT_NOT_RIGHT = 50003
    BD_STORAGE_NOT_SET = 50004
    BD_VOLUME_ID_INVALID = 50005
    BD_GET_BACKUP_MODE_FAILED = 50006
    BD_GET_STORAGE_UNIT_INFO_FAILED = 50007
    BD_BACKUP_PARAM_WRONG = 50008
    BD_STORAGE_TYPE_NOT_SUPPORT = 50009
    BD_BACKUP_STATE_NOT_RIGHT = 50010
    BD_IMPORT_TYPE_NOT_SUPPORT = 50011
    BD_IMPORT_STORAGE_UNIT_CAN_NOT_IS_S3 = 50012

    # KMS
    BD_CONNECT_KMS_FAILED = 50013
    BD_KMS_CERT_FILE_APTH_ILLEGAL = 50014

    # cinder backup failed
    BD_BACKUP_FAILED = 50015
    BD_RESTORE_FAILED = 50016
    BD_VERIFY_FAILED = 50017
    BD_DELETE_FAILED = 50018
    BD_IMPORT_RECORD_FAILED = 50019
    BD_EXPORT_RECORD_FAILED = 50020


class Constants:
    """ Global define"""

    TIME_SLEEP_5 = 5  # sleep 5 sec
    TIME_SLEEP_20 = 20  # sleep 20 sec
    TIME_SLEEP_30 = 30  # sleep 30 sec
    TIME_SLEEP_60 = 60  # sleep 60 sec
    TIME_SLEEP_90 = 90  # sleep 60 sec
    TIME_SLEEP_300 = 300

    DB_ERROR_RETRY_INTERVAL = 10  # sleep 10 sec
    DB_ERROR_RETRY_TIMES = 8

    ALL_NODE_UPDATE_WITH_REDO = 120  # sleep 120 sec

    LENGTH_LIMIT_36 = 36
    LENGTH_LIMIT_255 = 255
    VOLUME_SIZE_LENGTH = 12

    QUERY_COUNT = 36
    TASK_QUERY_COUNT = 45
    QUERY_ONE_DAY = 24 * 60 * 2
    CONNECT_COUNT = 30
    RETRY_COUNT = 36
    TASK_RETRY_COUNT = 3
    BUSINESS_RETRY_COUNT = 10
    WAIT_LOGIN_RETRY_COUNT = 24
    INVALID_TASK_RETRY_COUNT = 0
    INVALID_TASK_RETRY_TIME_INTERVAL = 0
    # The alarm threshold by pool/repository
    ALARM_THRESHOLD = 80

    # Binary capacity unit constants.
    Ki = 1024
    Mi = 1024 ** 2
    Gi = 1024 ** 3
    Ti = 1024 ** 4
    Pi = 1024 ** 5
    Ei = 1024 ** 6
    Zi = 1024 ** 7
    Yi = 1024 ** 8

    PLAN_STATUS_DEACTIVATION = 0
    PLAN_STATUS_ACTIVATION = 1
    PLAN_TYPE_ID = 57371
    POOL_TYPE_ID = 57357

    # backup mode
    INCREMENT_BACKUP = 1
    FULL_BACKUP = 2

    # Backup Command from INC
    BACKUP_CMD_FULL = 0
    BACKUP_CMD_INC = 1

    # import type
    IMPORT_TYPE_COPY = 1
    IMPORT_TYPE_DIFFERENT_AZ_RESTORE = 2
    IMPORT_TYPE_REMOTE_REPLICATION = 3
    IMPORT_TYPE_NATIVE_TO_CLOUD = 6
    IMPORT_TYPE_REMOTE_RESTORE = 7

    # Openstack Driver
    CHANNEL_TYPE = 1
    VOLUME_INDEX = '0000-0000-0000-0000'
    VOLUME_OFFSET = 0
    RESTORE_MODE_NEW = 1
    RESTORE_MODE_OLD = 0
    RESTORE_TYPE_VOLUME = 1

    # task status
    TASK_STATUS_FAILED = '6'
    TASK_STATUS_COMPLETED = '3'
    TASK_STATUS_STOP = '4'

    # backup status
    BACKUP_STATUS_AVALIBLE = 'available'
    BACKUP_STATUS_RESTORING = 'restoring'
    BACKUP_STATUS_CREATING = 'creating'
    BACKUP_STATUS_DELETING = 'deleting'
    BACKUP_STATUS_ERROR = 'error'

    # fail_reason
    GOOD_EXCEPTION = 'good exception'
    VERIFY_TASK_NOT_FOUND = "the task doesn't exist on eBackup"
    EBACKUP_DRIVER_RESTART = 'incomplete backup reset on manager restart'
    BACKUP_OS_IMAGE = 'backup is using as an os image'

    # const string
    NOID = 'R_no-id'

    # The task type on eBackup
    TASKTYPE_BACKUP = 1
    TASKTYPE_DEL_PLAN = 9
    TASKTYPE_DEL_COPY_PLAN = 20
    TASKTYPE_DEL_IMAGE = 5
    TASKTYPE_VOL_RESTORE = 10
    TASKTYPE_COPY = 19
    TASKTYPE_REMOTE_REPLICATION = 23
    TASKTYPE_REMOTE_RESTORE = 24
    TASKTYPE_VOL_REMOTE_RESTORE = 26
    TASKTYPE_NATIVE_TO_CLOUD = 99
    TASKTYPE_DIRECT_RESTORE = 999

    DOCKING_USER = 4

    # http code
    BAD_REQUEST = 400
    INTERBAL_SERVER_ERROR = 500
    MICROSERVICE_TIMEOUT = 406
    SERVER_TIMEOUT = 408
    SERVICE_UNAVAILABLE = 503
    EB_TOKEN_EXPIRED = 100
    EB_NO_AUTHENTICATION = -401
    HTTP_BAD_GATEWAY = 502
    HTTP_GATEWAY_TIMEOUT = 504

    # job_manager code
    JM_NO_AUTHENTICATION = 101

    # url reason
    ECONNREFUSED = '[Errno 111]'

    # The storage type 
    STORAGE_TYPE_VRM_FUSION_STORAGE = '0'
    STORAGE_TYPE_KVM_FUSION_STORAGE = '1'
    STORAGE_TYPE_VRMVIMS = '2'
    STORAGE_TYPE_KVMV3 = '3'
    STORAGE_TYPE_VRMV3 = '4'
    STORAGE_TYPE_VRMV3RDM = '5'
    STORAGE_TYPE_VRM_FUSION_RDM = '6'

    # Domain type
    DOMAIN_TYPE_COPY = 1
    DOMAIN_TYPE_BACKUP = 0
    DOMAIN_TYPE_REMOTE_REPLICATION = 3

    # storage type
    BACKUP_TYPE_MACHINE = 1
    BACKUP_TYPE_VOL = 0
    COPY_TYPE_SINGLE_VOL = 4
    COPY_TYPE_MACHINE = 5

    # KMS
    DATAKEY_LENGTH = 512
    DATAKEY_CIPER_LENGTH = 64

    # lld restore step
    STEP_LLD_START = 0
    STEP_LLD_SUCCESS = 1
    STEP_LLD_FAILED = 2
    STEP_HAS_REQUEST_STARTWITH_R = 3
    STEP_HAS_SERVER_REQUEST = 4

    # lld restore request tag
    TAG_LLD_START = 'R_lld_start'
    TAG_LLD_SUCCESS = 'R_lld_success'
    TAG_LLD_FAILED = 'R_lld_failed'

    # lld flag in backup
    LLD_DISABLED = 'lld_disabled'
    PLAN_NAME = 'plan_name'

    ACCERLERATERATE = 100

    #backup key
    PROVIDER_METADATA = 'provider_metadata'

    #evs key
    CMKID_KEY = 'CMKID'
    VK_KEY = 'VK'
    DEK_KEY = 'DEK'

    #rest ful method
    METHOD_PUT = 'put'
    METHOD_POST = 'post'
    METHOD_DELETE = 'delete'
    METHOD_GET = 'get'

    ip_v4_compile = '((?:(?:25[0-5]|2[0-4]\d|((1\d{2})|([1-9]?\d)))\.){3}(?:25[0-5]|2[0-4]\d|((1\d{2})|([1-9]?\d))))$'
    ip_v6_compile = '((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})' \
                    '|(([0-9A-Fa-f]{1,4}:){5}(:[0-9A-Fa-f]{1,4}){1,2})|(([0-9A-Fa-f]{1,4}:){4}(:[0-9A-Fa-f]' \
                    '{1,4}){1,3})|(([0-9A-Fa-f]{1,4}:){3}(:[0-9A-Fa-f]{1,4}){1,4})|(([0-9A-Fa-f]{1,4}:){2}' \
                    '(:[0-9A-Fa-f]{1,4}){1,5})|(([0-9A-Fa-f]{1,4})?:(:[0-9A-Fa-f]{1,4}){1,6})|(([0-9A-Fa-f]{1,4}:)' \
                    '{1,6}:)|(::)|(([0-9A-Fa-f]{1,4}:){6}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]?|0)' \
                    '(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]?|0)){3})|(([0-9A-Fa-f]{1,4}:){5}:' \
                    '(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]?|0)(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]' \
                    '|[1-9][0-9]?|0)){3})|(([0-9A-Fa-f]{1,4}:){4}:([0-9A-Fa-f]{1,4}:){0,1}(25[0-5]|2[0-4][0-9]' \
                    '|1[0-9][0-9]|[1-9][0-9]?|0)(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]?|0)){3})|' \
                    '(([0-9A-Fa-f]{1,4}:){3}:([0-9A-Fa-f]{1,4}:){0,2}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]?|0)' \
                    '(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]?|0)){3})|(([0-9A-Fa-f]{1,4}:){2}:' \
                    '([0-9A-Fa-f]{1,4}:){0,3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]?|0)' \
                    '(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]?|0)){3})|(([0-9A-Fa-f]{1,4})?::' \
                    '([0-9A-Fa-f]{1,4}:){0,4}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]?|0)' \
                    '(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]?|0)){3}))'

    XEN_TO_KVM = 'xentokvm'
